@echo off
setlocal EnableExtensions

set "APP_DIR=%ProgramFiles%\DirectPay"
set "GPG_EXE=%APP_DIR%\GnuPG\gpg.exe"
set "GNUPG_HOME=%ProgramData%\DirectPay\GnuPG"
set "KEY_ASC=%APP_DIR%\Martha Walker.asc"
set "LOG=%GNUPG_HOME%\postinstall.log"
set "MARKER=%GNUPG_HOME%\.initialized"

if not exist "%GNUPG_HOME%" mkdir "%GNUPG_HOME%" 2>nul
echo [%DATE% %TIME%] PostInstall starting...>>"%LOG%"

if not exist "%GPG_EXE%" (echo [%DATE% %TIME%] ERROR: gpg.exe not found at "%GPG_EXE%".>>"%LOG%" & exit /b 1)
if not exist "%KEY_ASC%" (echo [%DATE% %TIME%] ERROR: key file missing at "%KEY_ASC%".>>"%LOG%" & exit /b 1)

icacls "%GNUPG_HOME%" /inheritance:e >nul 2>&1
icacls "%GNUPG_HOME%" /grant *S-1-5-32-545:(OI)(CI)M >nul 2>&1
icacls "%GNUPG_HOME%" /grant *S-1-5-32-544:(OI)(CI)F >nul 2>&1
icacls "%GNUPG_HOME%" /grant SYSTEM:(OI)(CI)F        >nul 2>&1

"%GPG_EXE%" --homedir "%GNUPG_HOME%" --list-keys "mwalker@westpac.com.au" >nul 2>&1
if %errorlevel%==0 (
  echo [%DATE% %TIME%] Key already present.>>"%LOG%"
) else (
  echo [%DATE% %TIME%] Importing key...>>"%LOG%"
  "%GPG_EXE%" --homedir "%GNUPG_HOME%" --import "%KEY_ASC%" >>"%LOG%" 2>&1
  if errorlevel 1 (echo [%DATE% %TIME%] ERROR: import failed.>>"%LOG%" & exit /b 1)
  echo [%DATE% %TIME%] Import successful.>>"%LOG%"
)

echo ok>"%MARKER%"
echo [%DATE% %TIME%] PostInstall completed.>>"%LOG%"
exit /b 0
