@echo off
setlocal EnableExtensions

if "%~1"=="" (
  echo Usage: CreateAES.bat "C:\path\to\DISDATA.PC1"
  exit /b 2
)

REM Auto-detect Program Files path
IF DEFINED PROCESSOR_ARCHITEW6432 (
  REM Running 32-bit process on 64-bit Windows
  set "GPG_EXE=%ProgramFiles(x86)%\DirectPay\GnuPG\gpg.exe"
) ELSE IF "%PROCESSOR_ARCHITECTURE%"=="AMD64" (
  REM Running 64-bit process on 64-bit Windows
  set "GPG_EXE=%ProgramFiles%\DirectPay\GnuPG\gpg.exe"
) ELSE (
  REM 32-bit Windows
  set "GPG_EXE=%ProgramFiles%\DirectPay\GnuPG\gpg.exe"
)

set "GNUPG_HOME=%ProgramData%\DirectPay\GnuPG"

if not exist "%GPG_EXE%" ( echo ERROR: gpg.exe not found at "%GPG_EXE%". & exit /b 1 )

set "INFILE=%~1"
if not exist "%INFILE%" ( echo ERROR: Input not found: "%INFILE%". & exit /b 1 )

set "OUTDIR=%~dp1"
set "BASENAME=%~n1"
set "OUTFILE=%OUTDIR%%BASENAME%.pc1.asc"

"%GPG_EXE%" --homedir "%GNUPG_HOME%" --yes --batch --trust-model always --armor ^
  --recipient mwalker@westpac.com.au ^
  --output "%OUTFILE%" --encrypt "%INFILE%"

if errorlevel 1 ( echo ERROR: Encryption failed. & exit /b 1 )

echo SUCCESS: "%OUTFILE%" created.
exit /b 0