@echo off
setlocal EnableExtensions

REM Auto-detect Program Files path
IF DEFINED PROCESSOR_ARCHITEW6432 (
  REM Running 32-bit process on 64-bit Windows
  set "GPG_EXE=%ProgramFiles(x86)%\DirectPay\GnuPG\gpg.exe"
  set "KEY_ASC=%ProgramFiles(x86)%\DirectPay\Martha Walker.asc"
) ELSE IF "%PROCESSOR_ARCHITECTURE%"=="AMD64" (
  REM Running 64-bit process on 64-bit Windows
  set "GPG_EXE=%ProgramFiles%\DirectPay\GnuPG\gpg.exe"
  set "KEY_ASC=%ProgramFiles%\DirectPay\Martha Walker.asc"
) ELSE (
  REM 32-bit Windows
  set "GPG_EXE=%ProgramFiles%\DirectPay\GnuPG\gpg.exe"
  set "KEY_ASC=%ProgramFiles%\DirectPay\Martha Walker.asc"
)

set "GNUPG_HOME=%ProgramData%\DirectPay\GnuPG"

if not exist "%GPG_EXE%" ( echo ERROR: gpg.exe not found. & exit /b 1 )
if not exist "%KEY_ASC%" ( echo ERROR: Key file not found. & exit /b 1 )
if not exist "%GNUPG_HOME%" mkdir "%GNUPG_HOME%" 2>nul

"%GPG_EXE%" --homedir "%GNUPG_HOME%" --list-keys "mwalker@westpac.com.au" >nul 2>&1
if %errorlevel%==0 ( echo Key already present. & exit /b 0 )

"%GPG_EXE%" --homedir "%GNUPG_HOME%" --import "%KEY_ASC%"
if errorlevel 1 ( echo ERROR: Import failed. & exit /b 1 )

echo Imported Westpac key into shared keyring.
exit /b 0